﻿using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MettlerToledo.IND780.Information;
using MettlerToledo.IND780.SharedDataClient;
using MettlerToledo.IND780.Softkeys;

namespace MyFirstCustomApplication
{
	public partial class Form1 : Form
	{
		SDclient sdClient = new SDclient();
		Softkeys mySoftkeys = new Softkeys();

		public Form1()
		{
			InitializeComponent();

			this.ConnectToSDclient();	// First connect to the shared data server

			this.RegisterCallbacks();	// Register all callbacks

			this.SoftkeysInitialization();

			this.RegisterSoftkeys();
		}


		private void ConnectToSDclient()
		{
			int connectState = sdClient.ConnectToSharedDataServer("admin", "");

			if (connectState == 0)
				this.lbl_terminal_info_data.Text = "SD Server Connection Successful";
			else
				this.lbl_terminal_info_data.Text = "SD Server Connection Failed";
		}

		private void RegisterCallbacks()
		{
			sdClient.RegisterCallback((SDclient.MyCallbackDelegate)MyWeightUpdateCallback, "wt0102");
		}

		// This method invokes the callback method UpdateWeight
		public void MyWeightUpdateCallback(string sdName, string sdValue)
		{
			Invoke(new SDclient.MyCallbackDelegate(UpdateWeight), new object[] { sdName, sdValue });
		}

		public void UpdateWeight(string sdName, string sdValue)
		{
			this.lbl_weight_data.Text = sdValue + " " + sdClient.ReadSharedData("wt0103");
		}

		// Initialize the softkeys area at 195 pixels from the top of the form
		private void SoftkeysInitialization()
		{
			mySoftkeys.AllocateSoftkeys(this, 195, @"Storage Card\Terminal\SKBMP\COLOR\");
		}

		// The paint event handler is needed to draw the softkeys borders
		private void Form1_Paint(object sender, PaintEventArgs e)
		{
			mySoftkeys.DrawSoftkeyBorders(this);
		}

		private void RegisterSoftkeys()
		{
			// level 0 softkeys
			mySoftkeys.LoadSoftkeys(0, 0, true, @"Storage Card\Terminal\SKBMP\COLOR\info.bmp",
			(Softkeys.mySKMethodDelegate)ShowInformation);

			mySoftkeys.LoadSoftkeys(0, 3, true,	@"Storage Card\Terminal\SKBMP\COLOR\output on.bmp",
			(Softkeys.mySKMethodDelegate)DiscreteOutputOn);

			mySoftkeys.LoadSoftkeys(0, 4, true, @"Storage Card\Terminal\SKBMP\COLOR\output off.bmp",
			(Softkeys.mySKMethodDelegate)DiscreteOutputOff);

			mySoftkeys.NumberOfLevels = 1;

			mySoftkeys.DisplaySoftKeys(0);
		}

		private void ShowInformation()
		{
			InfoClass info = new InfoClass();
		}

		private void DiscreteOutputOn()
		{
			sdClient.SetSharedData("di0505", "1");	// turn on 0.5.1
			this.lbl_terminal_info_data.Text = "Output 0.5.1 should be ON";
		}

		private void DiscreteOutputOff()
		{
			sdClient.SetSharedData("di0505", "0");	// turn off 0.5.1
			this.lbl_terminal_info_data.Text = "Output 0.5.1 should be OFF";
		}

		// a keyUp event is needed to read the key code.  The softkey dispatcher handles which delegate method is called
		private void Form1_KeyUp(object sender, KeyEventArgs e)
		{
			mySoftkeys.SoftkeyDispatcher((int)e.KeyCode);
		}

	}

}